#include "Flag.h"
#include "Level.h"


Flag::Flag()
{
	setCollider(false);

	spriteType = SpriteType::FlagSprite;

	spriteTexture.loadFromFile("Assets/Sprites/Game Items/Flag/flag.png");	// Load the flag texture
	setTexture(&spriteTexture);
	setSize(sf::Vector2f(55, 54));
	setAlive(true);
}


Flag::~Flag()
{
}

void Flag::update(float dt)
{
	if (slideFlag)	//If the flag should slide down the pole
	{
		slideDownPole(dt);	//Slide the flag
	}
}

bool Flag::slideDownPole(float dt)
{
	setVelocity(sf::Vector2f(0, (3.f / 2.f) * scale));	//Set a positive y velocity to begin the slide

	if (getPosition().y >= 580 && slideFlag)	//If the flag is at the bottom of the pole
	{
		setPosition(getPosition().x, 580);	//Correct its exact position to the bottom
		setVelocity(sf::Vector2f(0, 0));	//Stop the flag movement
		slideFlag = false;	//We should no longer slide the flag
		Level::audioManager->playMusicByName("LevelComplete", false);
		return true;	//Return true, i.e. the flag has reached the bottom so Mario can move toward the castle
	}

	move(velocity.x * dt, velocity.y * dt);	//Move the flag
	return false;	//Return false, i.e. the flag has NOT reached the bottom of the pole
}